using System;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class SPATIENTDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public SPATIENTDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, SPATIENT objSave)
        {
            Int32? objReturn = objSave.PK_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_SPATIENT_save(CURRENT_USER, 
                        CURRENT_REGISTRY_ID,
                        objSave.AddressChangeInstitutionIEN,
                        objSave.AddressChangeInstitutionSID,
                        objSave.AddressChangeStaffIEN,
                        objSave.AddressChangeStaffSID,
                        objSave.Age,
                        objSave.BadAddressIndicator,
                        objSave.CDDeterminingInstitutionIEN,
                        objSave.City,
                        objSave.CombatFromVistaDate,
                        objSave.CombatToVistaDate,
                        char.Parse(objSave.ConfidentialAddressActiveFlag),
                        objSave.Country,
                        objSave.CountryIEN,
                        objSave.CountrySID,
                        objSave.County,
                        DateTime.Now,
                        objSave.CreatedBy,
                        objSave.CurrentMeansTestStatusIEN,
                        objSave.DateOfBirth,
                        objSave.DateOfBirthText,
                        objSave.DateOfDeath,
                        objSave.DateOfDeathText,
                        char.Parse(objSave.Deceased),
                        objSave.DEFAULT_RECORD,
                        objSave.Eligibility,
                        objSave.EligibilityIEN,
                        objSave.EligibilitySID,
                        objSave.EligibilityStatus,
                        objSave.EligibilityVACode,
                        objSave.EligibilityVerificationSource,
                        objSave.EmailAddress,
                        objSave.EnteredIntoFileDate,
                        objSave.EnteredIntoFileDateTransformSID,
                        objSave.EnteredIntoFileVistaErrorDate,
                        objSave.ETLBatchID,
                        char.Parse(objSave.ExcludeFromFacilityDirectoryFlag),
                        char.Parse(objSave.Gender),
                        objSave.GISAddressType,
                        objSave.GISAddressUpdatedDate,
                        objSave.GISCongressDistrict,
                        objSave.GISFIPSCode,
                        objSave.GISLocatorName,
                        objSave.GISMarket,
                        objSave.GISMatchedAddress,
                        objSave.GISMatchMethodCode,
                        objSave.GISMatchScore,
                        objSave.GISMatchStatusCode,
                        objSave.GISPatientAddressLatitude,
                        objSave.GISPatientAddressLongitude,
                        objSave.GISSector,
                        objSave.GISStreetSide,
                        objSave.GISSubmarket,
                        char.Parse(objSave.GISURH),
                        char.Parse(objSave.InsuranceCoverageFlag),
                        objSave.LastServiceEntryDate,
                        objSave.LastServiceEntryDateTransformSID,
                        objSave.LastServiceEntryVistaErrorDate,
                        objSave.LastServiceSeparationDate,
                        objSave.LastServiceSeparationDateTransformSID,
                        objSave.LastServiceSeparationVistaErrorDate,
                        objSave.MaritalStatus,
                        objSave.MaritalStatusIEN,
                        objSave.MaritalStatusSID,
                        objSave.MedicaidNumber,
                        objSave.MothersMaidenName,
                        objSave.OEF_OIF_IND,
                        char.Parse(objSave.OpCode),
                        objSave.Patient_ID,
                        objSave.PatientFirstName,
                        objSave.PatientICN,
                        objSave.PatientICNChecksum,
                        objSave.PatientIEN,
                        objSave.PatientLastName,
                        objSave.PatientName,
                        objSave.PatientSID,
                        objSave.PatientSnum,
                        objSave.PercentServiceConnect,
                        objSave.PeriodOfService,
                        objSave.PeriodOfServiceIEN,
                        objSave.PeriodOfServiceSID,
                        objSave.PhoneCellular,
                        objSave.PhoneResidence,
                        objSave.PhoneWork,
                        ref objReturn,
                        objSave.PostalCode,
                        objSave.POWLocationIEN,
                        objSave.PreferredInstitutionIEN,
                        objSave.Province,
                        char.Parse(objSave.PseudoSSNFlag),
                        objSave.PurpleHeartInstitutionIEN,
                        objSave.Race,
                        objSave.RaceIEN,
                        objSave.RaceSID,
                        objSave.Religion,
                        objSave.ReligionIEN,
                        objSave.ReligionSID,
                        objSave.RoomBedIEN,
                        objSave.ScrSnum,
                        char.Parse(objSave.SensitiveFlag),
                        objSave.Sta3n,
                        objSave.State,
                        objSave.StateIEN,
                        objSave.StateSID,
                        objSave.STD_COMBATLOCATION_ID,
                        objSave.STD_ENTHNICITY_ID,
                        objSave.STD_GENDER_ID,
                        objSave.STD_MARITALSTATUS_ID,
                        objSave.STD_RACE_ID,
                        objSave.STD_SERVICEBRANCH_ID,
                        objSave.StdRegistryId,
                        objSave.StreetAddress1,
                        objSave.StreetAddress2,
                        objSave.StreetAddress3,
                        objSave.TemporaryAddressChangeInstitutionIEN,
                        DateTime.Now,
                        objSave.UpdatedBy,
                        char.Parse(objSave.VeteranFlag),
                        objSave.VistaCreateDate,
                        objSave.VistaEditDate,
                        objSave.Zip,
                        objSave.Zip4);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        #endregion
    }
}
